# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from ..sdpackage import SDPackage
from .sdmdlgraph import SDMDLGraph
from ..sdapiobject import SDAPIObject
from ..sdapiobject import SDApiError
from ..apiexception import APIException

class SDMDLExporter(SDAPIObject):
    """
    Utility to export MDL modules and presets
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDMDLExporter
        """
        super(SDMDLExporter, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sExportPackage(sdPackage : SDPackage, mdlModuleFilePath : str) -> None:
        """
        Export the specified SDPackage to the specified MDL module file

        :param sdPackage: The SDPackage to export
        :param mdlModuleFilePath: The file path of the MDL Module that will be generated
        """
        _res = sd.getContext().SDMDLExporter_sExportPackage(sdPackage.mHandle, ctypes.create_string_buffer(mdlModuleFilePath.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    @staticmethod
    def sExportPreset(sdMDLGraph : SDMDLGraph, mdlPresetModuleFilePath : str) -> None:
        """
        Export the specified SDMDLGraph as a preset to the specified MDL module file

        :param sdMDLGraph: The SDMDLGraph to export
        :param mdlPresetModuleFilePath: The file path of the MDL Module that will be generated
        """
        _res = sd.getContext().SDMDLExporter_sExportPreset(sdMDLGraph.mHandle, ctypes.create_string_buffer(mdlPresetModuleFilePath.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

